// Listbox module //

// following code makes air easier to breathe: //
function ListBox(x, y, w, h, style)
{
	if (!this instanceof ListBox)
	return new ListBox(x, y, w, h, style);
	
	/*Position*/
	this.x = x;
	this.y = y;
	this.w = w;
	this.h = h;
	/*Stuff*/
	this.items      = [];
	this.style      = style || new Style();
	this.useWindow  = true;
	this.useArrow   = true;
	this.fontHeight = this.style.font.getHeight();
	this.shown      = Math.floor(this.h / this.fontHeight);
	this.index      = 0;
	this.topIndex   = 0;
	this.numberList = false;
	this.onClick    = function(){};
	/*this.playSound  = true;*/
}

   /* This will populate the item list of the list box */

// - Passing an object as the value must require the additional
// property argument. It will push the list by one value.

// - Passing an array as the value will tell it to transfer
// all of that arrays values, or a certain property in that
// array if it's an array of objects. It will push the list
// by the size of the array.

// - Passing any other value does not require the property
// argument and will push the list by one.

// - Be careful on passing the property, it shouldn't be a
// reference to a function, object, or array.

// - You can't pass functions into the list, but you can use
// the list to reference a function elsewhere. For example,
// look at the menu code in Rad_Menu.js for details.

ListBox.prototype.populate = function(value, property)
{
	if (typeof value == 'object')
	{
		if (value.length != undefined) // hackish way to identify if the value is an array //
		{
			for (var i in value)
			{
				if (typeof value[i] == 'object')
				{
					if (typeof value[i][property] == 'function') Abort("Sorry: A function is an invalid property for a value in the ListBox object.", "Rad_ListBox.js", 48);
					this.items.push(value[i][property]);
				}
				else if(typeof value[i] != 'function') this.items.push(value[i]);
			}
		}
		else this.items.push(value[property]);
	}
	else if (typeof value != 'function') this.items.push(value);
	else Abort("Sorry: A function is an invalid value for the ListBox object.", "Rad_Listbox.js", 48);
}

// Will draw the listbox module //
ListBox.prototype.blit = function()
{
	if (this.useWindow)
		this.style.window.drawWindow(this.x, this.y, this.w, this.h)
	
	for (var i = 0; i < this.shown; ++i)
	{
		if (i < this.items.length)
		{
			if (i + this.topIndex == this.index) this.style.fontColor = this.style.colorDown;
			else this.style.fontColor = this.style.colorUp;
			var number = (this.numberList) ? (i + this.topIndex + 1) + ": " : "";
			this.style.drawText(this.x + this.style.arrow.width + 2, this.y + i * this.fontHeight, number + this.items[i + this.topIndex]);
			this.style.fontColor = this.style.colorUp;
		}
		if (Cursor.isWithin(this.x+this.style.arrow.width+2, this.y+i*this.fontHeight, this.w-this.style.arrow.width-18, this.fontHeight))
		{
			if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
			{
				Cursor.leftIdle = false;
				this.onClick();
			}
			else this.index = i+this.topIndex;
		}
		if (Cursor.isWithin(this.x+this.w-18, this.y, 18, 18)) {
			if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
			{
				Cursor.leftIdle = false;
				this.decrement();
			}
		}
		if (Cursor.isWithin(this.x+this.w-18, this.y+this.h-18, 18, 18)) {
			if (IsMouseButtonPressed(MOUSE_LEFT) && Cursor.leftIdle)
			{
				Cursor.leftIdle = false;
				this.increment();
			}
		}
	}
	
	if (this.useArrow && this.items.length > 0) this.style.arrow.blit(this.x, this.y + (this.index - this.topIndex) * this.fontHeight);
	if (this.topIndex > 0) this.style.upArrow.blit(this.x + this.w - this.style.upArrow.width, this.y);
	if (this.topIndex + this.shown < this.items.length)
		this.style.downArrow.blit(this.x + this.w - this.style.downArrow.width, this.y + this.fontHeight * this.shown - this.style.downArrow.height);
}

// Will set the index to a specific number //
ListBox.prototype.setIndex = function(num)
{
	this.index = num;
	this.topIndex = num;
}

ListBox.prototype.setItemHeight = function(num)
{
	this.fontHeight = num;
	this.shown = Math.floor(this.h / this.fontHeight);
}

// will add 1 to the index //
ListBox.prototype.increment = function()
{
	if (this.index < this.items.length-1)
	{	
		this.index++;
		if (this.index >= this.topIndex + this.shown) this.topIndex++;
	}
}

// will minus 1 from the index //
ListBox.prototype.decrement = function()
{
	if (this.index > 0)
	{
		this.index--;
		if (this.index < this.topIndex) this.topIndex--;
	}
}

// used to set the style of this list box //
ListBox.prototype.setStyle = function(style)
{
	this.style = style;
	this.fontHeight = this.style.font.getHeight();
	this.shown = Math.floor(this.h / this.fontHeight);
}